////////////////////////////////////////////////////////////////
//
//  PROGRAMA MULTIVIBRADOR AESTABLE CON ARDUINO
//
////////////////////////////////////////////////////////////////
// Este programa emprega o microcontrolador ATMEGA328P-PU con encapsulado PDIP28
// e un módulo de interfaz serie ttl-usb con ft232r

//definicións previas
#define PIN_ENTRADA 5
#define PIN_SAIDA   9
#define TEMPO1_MS 100
#define TEMPO2_MS 100

// conexións do microcontrolador
/*         
           ---------------
           |ATMEGA328P-PU|
     RESET | PC6     PC5 | A5
       RXD | PD0     PC4 | A4
       TXD | PD1     PC3 | A3
        D2 | PD2     PC2 | A2
        D3 | PD3     PC1 | A1
        D4 | PD4     PC0 | A0
       VCC | VCC     GND | GND
       GND | GND    AREF | 100nF
     XTAL1 | PB6     VCC | VCC
     XTAL2 | PB7     PB5 | D13
        D5 | PD5     PB4 | D12
        D6 | PD6     PB3 | D11
        D7 | PD7     PB2 | D10
        D8 | PB0     PB1 | D9
           ---------------
 */

////////////////////////////////////////////////////////////////

void setup() {
  // put your setup code here, to run once:
  // definición de entradas e saídas
  pinMode(PIN_ENTRADA,INPUT);
  pinMode(PIN_SAIDA, OUTPUT);

  digitalWrite(PIN_SAIDA,LOW); //saída desactivada
}

////////////////////////////////////////////////////////////////

void loop() {
  // put your main code here, to run repeatedly:

  boolean entrada;

  // primeiro facemos a lectura das entradas:
  entrada=digitalRead(PIN_ENTRADA);
  // se a entrada está activa fai un ciclo de oscilación
  if(entrada==HIGH)
  {
    digitalWrite(PIN_SAIDA,HIGH);
    delay(TEMPO1_MS);
    digitalWrite(PIN_SAIDA,LOW);
    delay(TEMPO2_MS);
  }

}

////////////////////////////////////////////////////////////////

