////////////////////////////////////////////////////////////////
//
//  PROGRAMA BIESTABLE R-S CON ARDUINO
//
////////////////////////////////////////////////////////////////
// Este programa emprega o microcontrolador ATMEGA328P-PU con encapsulado PDIP28
// e un módulo de interfaz serie ttl-usb con ft232r

//definicións previas
#define PIN_SET   5
#define PIN_RESET 6
#define PIN_Q     9
#define PIN_QN   10

// conexións do microcontrolador
/*         
           ---------------
           |ATMEGA328P-PU|
     RESET | PC6     PC5 | A5
       RXD | PD0     PC4 | A4
       TXD | PD1     PC3 | A3
        D2 | PD2     PC2 | A2
        D3 | PD3     PC1 | A1
        D4 | PD4     PC0 | A0
       VCC | VCC     GND | GND
       GND | GND    AREF | 100nF
     XTAL1 | PB6     VCC | VCC
     XTAL2 | PB7     PB5 | D13
        D5 | PD5     PB4 | D12
        D6 | PD6     PB3 | D11
        D7 | PD7     PB2 | D10
        D8 | PB0     PB1 | D9
           ---------------
 */

////////////////////////////////////////////////////////////////

boolean entrada_set, entrada_reset, saida_q, saida_qn;

void setup() {
  // put your setup code here, to run once:
  // definición de entradas e saídas
  pinMode(PIN_SET,   INPUT);
  pinMode(PIN_RESET, INPUT);
  pinMode(PIN_Q,    OUTPUT);
  pinMode(PIN_QN,   OUTPUT);

  saida_q =LOW;
  saida_qn=HIGH;
  digitalWrite(PIN_Q ,saida_q ); //saída desactivada
  digitalWrite(PIN_QN,saida_qn); //saída inversa activa
}

////////////////////////////////////////////////////////////////

void loop() {
  // put your main code here, to run repeatedly:

  // primeiro facemos a lectura das entradas:
  entrada_set   = digitalRead(PIN_SET  );
  entrada_reset = digitalRead(PIN_RESET);

  // se a entrada set está alta activa Q e desactiva QN
  if(entrada_set==HIGH) { saida_q=HIGH; saida_qn=LOW; }

  // se a entrada reset está alta activa Q e desactiva QN
  if(entrada_reset==HIGH) { saida_q=LOW; saida_qn=HIGH; }
  
  // transfire os valores das variables ós pins de saída
  digitalWrite(PIN_Q ,saida_q );
  digitalWrite(PIN_QN,saida_qn);

}

////////////////////////////////////////////////////////////////

