////////////////////////////////////////////////////////////////////
// BLINK 4BITS PORTOS
//   - Programa de manexo de bits dos portos en bloque para probar
//   códigos decimal, binario, hexadecimal
//   - instrucións DDRx (dirección bits do porto x, 1=saida)
//   - PORTx (escritura 8 bits no porto x)
//   - PINx (lectura 8 bits do porto x)  */
// conexións do microcontrolador
/*         ---------------
           |ATMEGA328P-PU|
     RESET | PC6     PC5 | A5
       RXD | PD0     PC4 | A4
       TXD | PD1     PC3 | A3
        D2 | PD2     PC2 | A2
        D3 | PD3     PC1 | A1
        D4 | PD4     PC0 | A0
       VCC | VCC     GND | GND
       GND | GND    AREF | 100nF
     XTAL1 | PB6     VCC | VCC
     XTAL2 | PB7     PB5 | D13
        D5 | PD5     PB4 | D12
        D6 | PD6     PB3 | D11
        D7 | PD7     PB2 | D10
        D8 | PB0     PB1 | D9
           ---------------  */

// función de inicialización
void setup() {
  // initialize digital pin 13 as an output.
  pinMode(13, OUTPUT);

  //establece pins 0-3 do porto D como saídas (0=entrada, 1=saida)
  DDRD = 0b00001111;
  
//  PORTD = 0B00001010; //binario
//  PORTD = 10; //decimal
  PORTD = 0X0A; //hexadecimal
}

// función de repetición
void loop() 
{
  //PORTD = 0X0A; //hexadecimal
  //PORTD = 10; //decimal
  PORTD = 0B00001010; //binario
  delay(1000);
  //PORTD = 0X05; //hexadecimal
  //PORTD = 5; //decimal
  PORTD = 0B00000101; //binario
  delay(1000);

}

