////////////////////////////////////////////////////////////////
//
//  PROGRAMA CONTADOR BINARIO/DECIMAL 4 BITS CON ARDUINO
//
////////////////////////////////////////////////////////////////
// Este programa emprega o microcontrolador ATMEGA328P-PU (PDIP28)
// e un módulo de interfaz serie ttl-usb con ft232r

//definicións previas
#define PIN_CLK   5
#define PIN_RESET 6
#define PIN_Q0    9
#define PIN_Q1   10
#define PIN_Q2   11
#define PIN_Q3   12

#define MAX_CONTADOR 9 //valor máximo de conta: 9 para decimal, 15 para binario

/* conexións do microcontrolador
           ---------------
           |ATMEGA328P-PU|
     RESET | PC6     PC5 | A5
       RXD | PD0     PC4 | A4
       TXD | PD1     PC3 | A3
        D2 | PD2     PC2 | A2
        D3 | PD3     PC1 | A1
        D4 | PD4     PC0 | A0
       VCC | VCC     GND | GND
       GND | GND    AREF | 100nF
     XTAL1 | PB6     VCC | VCC
     XTAL2 | PB7     PB5 | D13
        D5 | PD5     PB4 | D12
        D6 | PD6     PB3 | D11
        D7 | PD7     PB2 | D10
        D8 | PB0     PB1 | D9
           ---------------
 */

/* conexións do díxito (SA56) e decodificador (7447)

         g  f  AC a  b           VCC f  g  a  b  c  d  e
         10 9  8  7  6           16 15 14 13 12 11 10  9
         |  |  |  |  |            |  |  |  |  |  |  |  |
         -------------            ----------------------
         |  XXXXXXX  |            |                     |
         | X       X |            |                     |
         | X       X |            |                     |
         |  XXXXXXX  |            |        7447         |
         | X       X |            |                     |
         | X       X |            |                     |
         |  XXXXXXX  |            |                     |
         -------------            ----------------------
         |  |  |  |  |            |  |  |  |  |  |  |  |
         1  2  3  4  5            1  2  3  4  5  6  7  8
         e  d  AC c DP           A1 A2 LT BI RBI A3 A0 GND
 */
////////////////////////////////////////////////////////////////
// define variables globais de entradas e saidas
boolean entrada_clk_anterior, entrada_clk_actual, entrada_reset;
boolean saida_q0, saida_q1, saida_q2, saida_q3;
unsigned char contador;

void setup() {
  // put your setup code here, to run once:
  // definición de entradas e saídas
  pinMode(PIN_CLK,   INPUT);
  pinMode(PIN_RESET, INPUT);
  pinMode(PIN_Q0,   OUTPUT);
  pinMode(PIN_Q1,   OUTPUT);
  pinMode(PIN_Q2,   OUTPUT);
  pinMode(PIN_Q3,   OUTPUT);

  entrada_clk_anterior  = digitalRead(PIN_CLK);

  contador=0;
  saida_q0=bitRead(contador,0);
  saida_q1=bitRead(contador,1);
  saida_q2=bitRead(contador,2);
  saida_q3=bitRead(contador,3);
  digitalWrite(PIN_Q0,saida_q0);
  digitalWrite(PIN_Q1,saida_q1);
  digitalWrite(PIN_Q2,saida_q2);
  digitalWrite(PIN_Q3,saida_q3);
}

////////////////////////////////////////////////////////////////

void loop() {
  // put your main code here, to run repeatedly:

  // primeiro facemos a lectura das entradas:
  entrada_clk_actual  = digitalRead(PIN_CLK);
  entrada_reset = digitalRead(PIN_RESET);

  // compara o estado actual co anterior, se hai cambio avanza o contador
  if( (entrada_clk_actual==HIGH) && (entrada_clk_anterior==LOW) ) 
  {
    contador++;
    if (contador==MAX_CONTADOR+1) contador=0; 
  }
  
  // se a entrada reset está alta reinicia a conta
  if(entrada_reset==HIGH) { contador=0; }
  
  // transfire os valores das variables ós pins de saída
  saida_q0=bitRead(contador,0);
  saida_q1=bitRead(contador,1);
  saida_q2=bitRead(contador,2);
  saida_q3=bitRead(contador,3);
  digitalWrite(PIN_Q0,saida_q0);
  digitalWrite(PIN_Q1,saida_q1);
  digitalWrite(PIN_Q2,saida_q2);
  digitalWrite(PIN_Q3,saida_q3);

  //copia estado actual para o seguinte paso
  entrada_clk_anterior=entrada_clk_actual;
}

////////////////////////////////////////////////////////////////

