//////////////////////////////////////////////////////////////////////////
//  DIAPASÓN 4 NOTAS PARA VIOLÍN
//
// - frecuencias violín: sol3=196.0Hz, re4=293.7Hz, la4=440Hz, mi5=659.3Hz
//////////////////////////////////////////////////////////////////////////

// definicións de constantes do programa
#define TECLA1 4  //pin da tecla 1 (esquerda)
#define TECLA2 5  //pin da tecla 2 
#define TECLA3 6  //pin da tecla 3 
#define TECLA4 7  //pin da tecla 4 (dereita)
#define LED1 3  //pin do led 1 (esquerda)
#define LED2 2  //pin do led 2 
#define LED3 1  //pin do led 3 
#define LED4 0  //pin do led 4 (dereita)
#define FRECUENCIA1 196 //frecuencia SOL3 196.0Hz
#define FRECUENCIA2 294 //frecuencia RE4  293.7Hz
#define FRECUENCIA3 440 //frecuencia LA4  440.0Hz
#define FRECUENCIA4 659 //frecuencia MI5  659.3Hz
#define SPEAKER 10      //pin do altavoz
#define LED_PLACA 13    //pin do led integrado na placa

// código de inicialización de parámetros
void setup() 
{
  //define pins de teclas como entradas
  pinMode(TECLA1, INPUT);
  pinMode(TECLA2, INPUT);
  pinMode(TECLA3, INPUT);
  pinMode(TECLA4, INPUT);
  //define pins de leds como saídas
  pinMode(LED1, OUTPUT);
  pinMode(LED2, OUTPUT);
  pinMode(LED3, OUTPUT);
  pinMode(LED4, OUTPUT);
  //desactiva leds
  digitalWrite(LED1,HIGH);
  digitalWrite(LED2,HIGH);
  digitalWrite(LED3,HIGH);
  digitalWrite(LED4,HIGH);
}

// bucle do programa principal
// variables globais
int tecla, tecla1, tecla2, tecla3, tecla4;

void loop() 
{
  delay(200); //retardo entre lecturas
  tecla1=digitalRead(TECLA1); 
  tecla2=digitalRead(TECLA2); 
  tecla3=digitalRead(TECLA3); 
  tecla4=digitalRead(TECLA4); 
  
  // tecla1 pulsada: activa frecuencia 1 
  tecla=0; //valor de tecla pulsada (0=non, 1-2-3-4 número de tecla)
  if(tecla1==LOW) tecla=1;
  if(tecla2==LOW) tecla=2;
  if(tecla3==LOW) tecla=3;
  if(tecla4==LOW) tecla=4;

  switch(tecla)
  {
    case 0: noTone(SPEAKER); //desactiva tono  
            digitalWrite(LED1,HIGH); //desactiva leds
            digitalWrite(LED2,HIGH);
            digitalWrite(LED3,HIGH);
            digitalWrite(LED4,HIGH);
            break; 
    case 1: digitalWrite(LED1,LOW);    //activa led
            tone(SPEAKER,FRECUENCIA1); //activa tono  
            break; 
    case 2: digitalWrite(LED2,LOW);    //activa led
            tone(SPEAKER,FRECUENCIA2); //activa tono  
            break; 
    case 3: digitalWrite(LED3,LOW);    //activa led
            tone(SPEAKER,FRECUENCIA3); //activa tono  
            break; 
    case 4: digitalWrite(LED4,LOW);    //activa led
            tone(SPEAKER,FRECUENCIA4); //activa tono  
            break; 
  } // fin do switch

} //fin do programa

