///////////////////////////////////////////////////////////////////////////
//    funcións propias de control de visualizador lcd 2x16
///////////////////////////////////////////////////////////////////////////

/**************************************************************************
   funcións de control do visualizador LCD
   void retardo(unsigned char max)
   void lcd_enable()
   void lcd_busy()
   void lcd_orden(unsigned char valor)
   void lcd_dato(unsigned char valor)
   void lcd_ini()
   void lcd_borra()
   void lcd_cursor(unsigned char pos)
   void lcd_define_char()
   void lcd_vischar(unsigned char dat)
   void lcd_visbcd(unsigned char dat)
   void lcd_vishex(unsigned char dat)
   void lcd_viscad(const char* cad)
  
   Instruccións de control do display:
  
   FUNCION               RS R/W DB7 DB6 DB5 DB4 DB3 DB2 DB1 DB0
   Borrado display       0   0   0   0   0   0   0   0   0   1
   Cursor pos. 0         0   0   0   0   0   0   0   0   1   X
   Modos entrada datos   0   0   0   0   0   0   0   1   ID  S
   Control display       0   0   0   0   0   0   1   D   C   B
   Modos desprazamento   0   0   0   0   0   1   SC  RL  X   X
   Funcions display      0   0   0   0   1   DL  N   F   X   X
   Direccion CGRAM       0   0   0   1   - 6 bits direccion  -
   Direccion DDRAM       0   0   1   -   - 7 bits direccion  -
   Lectura BF e dir.     0   1   BF  -   - 7 bits contador   -
   Escritura datos       1   0   -   -   - 8 bits datos  -   -    
   Lectura datos         1   1   -   -   - 8 bits datos  -   -    
  
   significado dos bits: 
   X: indiferente
   ID: 0 decremento, 1 incremento
   S:  0 despraza display, 1 non despraza
   D:  0 display desconectado, 1 conectado
   C:  0 cursor invisible, 1 visible
   B:  0 cursor non parpadea, 1 parpadea
   SC: 0 despraza cursor, 1 despraza display
   RL: 0 despraza a esquerda, 1 a dereita
   DL: 0 conexion 4 bits, 1 conexion 8 bits
   N:  0 1 liña activa, 1 2 liñas activas
   F:  0 caracteres 5x7, 1 caracteres 5x10
   BF: 0 display libre, 1 ocupado
  
   CONECTOR:  GND +5 VEE RS R/W E DB0 DB1 DB2 DB3 DB4 DB5 DB6 DB7
               1   2  3   4  5  6  7   8   9  10  11  12  13  14 
  
   MODOS TRANSFERENCIA
   4 BITS: instrucci¢ns e datos en dous bloques de 4 bits, primeiro MSB.
   Precisa un total de 7 liñas de datos e 3 de alimentacion. Non se usa DB0-3. 
   8 BITS: instrucci¢ns e datos nunha £nica operacion de lectura/escritura.
   Precisa un total de 11 liñas de datos e 3 de alimentacion.
  
******************************************************************************/
// usa o porto D (pins 0-7)
// pins IDC10:   PLACA LCD         PLACA ATMEGA
//               D0- D1-D2-D3-VCC  PD0-PD1-PD2-PD3-VCC
//               TEC-EN-RW-RS-GND  PD7-PD6-PD5-PD4-GND
// (NOTA: os pins LCD_D0-3 do lcd están conectados a D4-D7 en modo 4 bits)
#define LCD_RS  4 //bit 4 do porto D
#define LCD_RW  5 //bit 5 do porto D
#define LCD_EN  6 //bit 6 do porto D
#define LCD_TEC 7 //bit 7 do porto D (1=esc/lec lcd, 0=lectura teclado)
#define LCD_D0  0 //bit 0 do porto D (bit 4 datos)
#define LCD_D1  1 //bit 1 do porto D (bit 5 datos)
#define LCD_D2  2 //bit 2 do porto D (bit 6 datos)
#define LCD_D3  3 //bit 3 do porto D (bit 7 datos)
#define LCD_BF  3 //bit 3 do porto D (bit de fin)

//definicións de estados de ENABLE
//EN normal  (0=off, 1=on)
#define LCD_EN_ON  1 //EN activo a 0
#define LCD_EN_OFF 0 //EN inactivo a 1
//EN inverso (1=off, 0=on)
//#define LCD_EN_ON  0 //EN activo a 0
//#define LCD_EN_OFF 1 //EN inactivo a 1

///////////////////////////////////////////////////////////////////////////
// rexistros de teclas
unsigned char tecla0,tecla1,tecla2,tecla3; //rexistros de teclas
// bits inferiores (0-3): contador pulsacions 0-15, 
// bit 4: estado anterior (1=pulsada), bit 7: indicador de pulsación (1=pulsada)

///////////////////////////////////////////////////////////////////////////
//función de retardo en us*100
void retardo(unsigned char max)
{
  unsigned char cont;
  for (cont=0;cont<max;cont++)
    delayMicroseconds(100); //espera 100us
}
///////////////////////////////////////////////////////////////////////////
// función que inicializa o display e o pon en modo de 4 bits, 
// 2 liñas en pantalla, fonte de 5x7 puntos en cursor invisible
// (non se pode usar a función busy ata que o display está inicializado)
// non se pode modificar o bit 3 (se usa para lectura de teclas)
void lcd_ini()
{
  //inicializa entradas e saídas do micro
  pinMode(LCD_RS,  OUTPUT);  
  pinMode(LCD_RW,  OUTPUT);  
  pinMode(LCD_EN,  OUTPUT);  
  pinMode(LCD_TEC, OUTPUT);  
  pinMode(LCD_D0,  OUTPUT);  
  pinMode(LCD_D1,  OUTPUT);  
  pinMode(LCD_D2,  OUTPUT);  
  pinMode(LCD_D3,  OUTPUT);  
  
  digitalWrite(LCD_TEC, 1); //selecciona lcd
  digitalWrite(LCD_RS,  0); //display en modo orden
  digitalWrite(LCD_RW,  0); //display en modo escritura
  digitalWrite(LCD_EN,  LCD_EN_OFF); //desactiva enable
  retardo(50); // retardo inicial 5ms
  // envía dato 0x30: 8 bits, 2 liñas, car 5x7
  digitalWrite(LCD_D3,0);digitalWrite(LCD_D2,0);digitalWrite(LCD_D1,1);digitalWrite(LCD_D0,1); 
  lcd_enable();
  retardo(50); // retardo inicial 5ms
  // envía dato 0x30: 8 bits, 2 liñas, car 5x7
  digitalWrite(LCD_D3,0);digitalWrite(LCD_D2,0);digitalWrite(LCD_D1,1);digitalWrite(LCD_D0,1); 
  lcd_enable();
  retardo(50); // retardo inicial 5ms
  // envía dato 0x30: 8 bits, 2 liñas, car 5x7
  digitalWrite(LCD_D3,0);digitalWrite(LCD_D2,0);digitalWrite(LCD_D1,1);digitalWrite(LCD_D0,1); 
  lcd_enable();
  retardo(50); // retardo inicial 5ms
  // envía dato 0x20: 4 bits, 2 liñas, car 5x7
  digitalWrite(LCD_D3,0);digitalWrite(LCD_D2,0);digitalWrite(LCD_D1,1);digitalWrite(LCD_D0,0); 
  digitalWrite(LCD_RS,0); //display en modo orden
  digitalWrite(LCD_RW,0); //display en modo escritura
  lcd_enable();
  retardo(50); // retardo inicial 5ms
  //  agora xa se pode empregar ordenlcd() 
  lcd_orden(0x28); // interfaz 4 bits, 2 liñas, fonte 5x7 
  lcd_orden(0x0c); // lcd on, cursor off, blink off 
  lcd_orden(0x01); // borrado total display 
  lcd_orden(0x80); // memoria datos, posición 0 
  lcd_orden(0x06); // despraza o display e incremento cursor 
  lcd_orden(0x14); // despraza cursor á dereita 

  //borra rexistros de teclas
  tecla0=0;tecla1=0;tecla2=0;tecla3=0;
}
///////////////////////////////////////////////////////////////////////////
// función que xera un pulso de activación na pata enable
void lcd_enable()
{
  digitalWrite(LCD_EN,LCD_EN_ON); //activa enable
  delayMicroseconds(10); //espera 10us
  digitalWrite(LCD_EN,LCD_EN_OFF); //desactiva enable
}
///////////////////////////////////////////////////////////////////////////
// función que espera ata que o visualizador finalice a operacion en curso
// e quede libre para recibir novos datos ou ordes
// NOTA: non se deben modificar os bits inferiores, especialmente EN
void lcd_busy()
{
  digitalWrite(LCD_TEC,1); //selecciona lcd
  digitalWrite(LCD_RS,0);  //display en modo orden
  digitalWrite(LCD_RW,1);  //display en modo lectura
  digitalWrite(LCD_EN,LCD_EN_ON);  //activa enable
  digitalWrite(LCD_BF,1);  //bit bf como entrada para lectura
  pinMode(LCD_BF,INPUT);   //pin bf en modo entrada
  delayMicroseconds(10);   //retardo
  while(digitalRead(LCD_BF)==1); //espera mentres bf=1
  pinMode(LCD_BF,OUTPUT);  //pin bf en modo saída
  digitalWrite(LCD_EN,LCD_EN_OFF);  //desactiva enable
  delayMicroseconds(10);   //retardo
  lcd_enable();            //envía pulso enable completo
  digitalWrite(LCD_RW,0);  //display en modo escritura
}
///////////////////////////////////////////////////////////////////////////
//función que recibe unha orden e a envía ó visualizador (formato 4 bits)
void lcd_orden(unsigned char valor)
{
  lcd_busy(); //espera a que finalice a operación anterior
  digitalWrite(LCD_RS,0);  //display en modo orden
  digitalWrite(LCD_RW,0);  //display en modo escritura
  if(valor&0x10) digitalWrite(LCD_D0,1); else digitalWrite(LCD_D0,0);
  if(valor&0x20) digitalWrite(LCD_D1,1); else digitalWrite(LCD_D1,0);
  if(valor&0x40) digitalWrite(LCD_D2,1); else digitalWrite(LCD_D2,0);
  if(valor&0x80) digitalWrite(LCD_D3,1); else digitalWrite(LCD_D3,0);
  lcd_enable(); //orden de escritura
  if(valor&0x01) digitalWrite(LCD_D0,1); else digitalWrite(LCD_D0,0);
  if(valor&0x02) digitalWrite(LCD_D1,1); else digitalWrite(LCD_D1,0);
  if(valor&0x04) digitalWrite(LCD_D2,1); else digitalWrite(LCD_D2,0);
  if(valor&0x08) digitalWrite(LCD_D3,1); else digitalWrite(LCD_D3,0);
  lcd_enable(); //orden de escritura
}
///////////////////////////////////////////////////////////////////////////
//función que recibe un dato e o envía ó visualizador (formato 4 bits)
//serve tanto para enviar datos á ddram como á cgram
void lcd_dato(unsigned char valor)
{
  lcd_busy(); //espera a que finalice a operación anterior
  digitalWrite(LCD_RS,1);  //display en modo datos
  digitalWrite(LCD_RW,0);  //display en modo escritura
  if(valor&0x10) digitalWrite(LCD_D0,1); else digitalWrite(LCD_D0,0);
  if(valor&0x20) digitalWrite(LCD_D1,1); else digitalWrite(LCD_D1,0);
  if(valor&0x40) digitalWrite(LCD_D2,1); else digitalWrite(LCD_D2,0);
  if(valor&0x80) digitalWrite(LCD_D3,1); else digitalWrite(LCD_D3,0);
  lcd_enable(); //orden de escritura
  if(valor&0x01) digitalWrite(LCD_D0,1); else digitalWrite(LCD_D0,0);
  if(valor&0x02) digitalWrite(LCD_D1,1); else digitalWrite(LCD_D1,0);
  if(valor&0x04) digitalWrite(LCD_D2,1); else digitalWrite(LCD_D2,0);
  if(valor&0x08) digitalWrite(LCD_D3,1); else digitalWrite(LCD_D3,0);
  lcd_enable(); //orden de escritura
}
///////////////////////////////////////////////////////////////////////////
//función que borra o visualizador e leva o cursor a posición de inicio
void lcd_borra()
{
  lcd_orden(0x01);
  retardo(100);
}

///////////////////////////////////////////////////////////////////////////
// función que move o cursor á posición indicada
// codigos das posicions de pantalla:
// valores 0-15 primeira liña, valores 16-31 segunda liña
// a rutina fai unha conversion segundo os seguintes valores:
// liña1:  0  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15
// liña2: 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 
void lcd_cursor(unsigned char pos)
{
  if(pos&0x10) pos=pos|0x40; //>15 engade suma 64
  pos=pos&0x4f; //elimina bits superiores excepto 6 
  pos=pos|0x80; //engade posición de escritura ddram
  lcd_orden(pos);
}

///////////////////////////////////////////////////////////////////////////
//  constantes para xeración de caracteres adicionais
//  estes datos gárdanse na memoria de programa 
//  letra 'á'   letra 'é'   letra 'í'   letra 'ó'   letra 'ú' letra 'ñ'
//  00000010b 00000010b 00000010b 00000010b 00000010b 00001101b
//  00000100b 00000100b 00000100b 00000100b 00000100b 00010010b
//  00001110b 00001110b 00001100b 00001110b 00010001b 00010110b
//  00000001b 00010001b 00000100b 00010001b 00010001b 00011001b
//  00001111b 00011111b 00000100b 00010001b 00010001b 00010001b
//  00010001b 00010000b 00000100b 00010001b 00010011b 00010001b
//  00001111b 00001110b 00001110b 00001110b 00001101b 00010001b
//  00000000b 00000000b 00000000b 00000000b 00000000b 00000000b

const unsigned char lcd_datos_caracteres[]={
  48, //lonxitude de datos
  0x02,0x04,0x0e,0x01,0x0f,0x11,0x0f,0x00, //'á'
  0x02,0x04,0x0e,0x11,0x1f,0x10,0x0e,0x00, //'é'
  0x02,0x04,0x0c,0x04,0x04,0x04,0x0e,0x00, //'í'
  0x02,0x04,0x0e,0x11,0x11,0x11,0x0e,0x00, //'ó'
  0x02,0x04,0x11,0x11,0x11,0x13,0x0d,0x00, //'ú'
  0x0d,0x12,0x16,0x19,0x11,0x11,0x11,0x00  //'ñ'
  };
///////////////////////////////////////////////////////////////////////////
/* función que envía os novos caracteres á memoria cgram */
void lcd_define_caracteres()
{
  unsigned char i;
  
  for(i=0;i<lcd_datos_caracteres[0];i++)
  {
    lcd_orden(0x40+i);
    lcd_dato(lcd_datos_caracteres[i+1]);
  }
  lcd_orden(0x80);
}

///////////////////////////////////////////////////////////////////////////
/* función que envía ó display o carácter indicado na posición actual do cursor */
void lcd_vischar(unsigned char dat)
{
  lcd_dato(dat);
}
///////////////////////////////////////////////////////////////////////////
/* función que envía ó display o valor en bcd (dous díxitos, valores 0-100) 
   do carácter indicado na posición actual do cursor */
void lcd_visbcd(unsigned char dat)
{
  char temp;
  
  temp=dat/10;
  lcd_dato(0x30+temp);
  temp=temp*10;
  temp=dat-temp;
  lcd_dato(0x30+temp);
}
///////////////////////////////////////////////////////////////////////////
/* función que envía ó display o valor en hex (dous díxitos) 
   do carácter indicado na posición actual do cursor 
   método: extraer 4 bits superiores-inferiores
   se valor>=10 (letras A-F) súmase 0x37 -> 0x41='A' 
   se valor<10 (números 0-9) súmase 0x30 -> 0x30='0'    */
void lcd_vishex(unsigned char dat)
{
  char temp;

  temp=dat>>4;        //selecciona 4 bits superiores
  if(temp>9) temp=temp+0x37;  //letras A-F en ascii
  else temp=temp+0x30;    //dixitos 0-9 en ascii
  lcd_dato(temp);       //envía valor ó visualizador
  temp=dat&0x0f;        //selecciona 4 bits inferiores
  if(temp>9) temp=temp+0x37;  //letras A-F en ascii
  else temp=temp+0x30;    //dixitos 0-9 en ascii
  lcd_dato(temp);       //envía valor ó visualizador
}
///////////////////////////////////////////////////////////////////////////
/* función que envía ó display a cadena de caracteres indicada ata que atope 
   o valor 0. A visualización faise a partir da posición actual do cursor
   esta función non salta liñas do display */
void lcd_viscad(const char* cad)
{
  char i=0;
  
  while(cad[i]>0) 
  { lcd_dato(cad[i]);
    i++; }
}
///////////////////////////////////////////////////////////////////////////

// función auxiliar que actualiza o rexistro de tecla
unsigned char lee_tecla(unsigned char rexistro, int pin)
{
  if(digitalRead(pin)==1) //estado actual non pulsada
  { rexistro=0; } //contador e indicadores a 0
  else //estado actual pulsada
  { //comproba estado anterior (bit 4, 0 = non pulsada)
    if(rexistro&0x10) //estado anterior pulsada
    { //incrementa contador se non chegóu ó máximo (4LSB=0x0f)
      //sábese se rexistro<0x1f (tecla pulsada+contador=0x0f)
      //se está activado o bit 7 o valor>0x80, tampouco incrementa
      if(rexistro<0x1f) 
      { rexistro++;
        //se chega ó máximo activa indicador de tecla
        if(rexistro==0x1f) rexistro=0x9f; 
      }
    }
    else //estado anterior non pulsada, activa indicador e contador=0 
    { rexistro=0x10; }
  }
  return rexistro;
}

///////////////////////////////////////////////////////////////////////////
// función de lectura de teclado
// - devolve o número da tecla pulsada (1-4) ou 0 se non hai
// - se hai varias teclas devolve a primeira, as seguintes devólvense 
// nas sucesivas chamadas á función
// - cando devolve unha tecla borra o indicador no rexistro asociado
unsigned char lee_teclado()
{
  unsigned char valor=0;
  //lectura de teclas
  digitalWrite(LCD_TEC,0); //selecciona teclado
  //bits datos como entrada
  digitalWrite(LCD_D3,1);digitalWrite(LCD_D2,1);digitalWrite(LCD_D1,1);digitalWrite(LCD_D0,1); 
  pinMode(LCD_D3,INPUT);pinMode(LCD_D2,INPUT);pinMode(LCD_D1,INPUT);pinMode(LCD_D0,INPUT);
  retardo(100); // retardo 10ms en cada paso de programa

  //actualiza rexistros de teclas
  tecla0=lee_tecla(tecla0,LCD_D0); 
  tecla1=lee_tecla(tecla1,LCD_D1); 
  tecla2=lee_tecla(tecla2,LCD_D2); 
  tecla3=lee_tecla(tecla3,LCD_D3); 

  digitalWrite(LCD_TEC,1); //selecciona lcd
  //bit datos como saída
  pinMode(LCD_D3,OUTPUT);pinMode(LCD_D2,OUTPUT);pinMode(LCD_D1,OUTPUT);pinMode(LCD_D0,OUTPUT);

  // se hai algunha tecla pulsada devolve o primeiro valor (o resto quedan pendentes)
  if(tecla0&0x80) { tecla0=tecla0&0x7f; return 1; }
  if(tecla1&0x80) { tecla1=tecla1&0x7f; return 2; }
  if(tecla2&0x80) { tecla2=tecla2&0x7f; return 3; }
  if(tecla3&0x80) { tecla3=tecla3&0x7f; return 4; }
  //se non hai tecla pulsada devolve 0
  return 0;
} 

///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////

