////////////////////////////////////////////////////////////////
//
//  PROGRAMA MONOESTABLE CON ARDUINO
//
////////////////////////////////////////////////////////////////
// Este programa emprega o microcontrolador ATMEGA328P-PU con encapsulado PDIP28
// e un módulo de interfaz serie ttl-usb con ft232r

//definicións previas
#define PIN_ENTRADA 5
#define PIN_SAIDA   9
#define TEMPO_MS 2000

// conexións do microcontrolador
/*         
           ---------------
           |ATMEGA328P-PU|
     RESET | PC6     PC5 | A5
       RXD | PD0     PC4 | A4
       TXD | PD1     PC3 | A3
        D2 | PD2     PC2 | A2
        D3 | PD3     PC1 | A1
        D4 | PD4     PC0 | A0
       VCC | VCC     GND | GND
       GND | GND    AREF | 100nF
     XTAL1 | PB6     VCC | VCC
     XTAL2 | PB7     PB5 | D13
        D5 | PD5     PB4 | D12
        D6 | PD6     PB3 | D11
        D7 | PD7     PB2 | D10
        D8 | PB0     PB1 | D9
           ---------------
 */

////////////////////////////////////////////////////////////////

boolean entrada_anterior;

void setup() {
  // put your setup code here, to run once:
  // definición de entradas e saídas
  pinMode(PIN_ENTRADA,INPUT);
  pinMode(PIN_SAIDA, OUTPUT);

  digitalWrite(PIN_SAIDA,LOW); //saída desactivada
  entrada_anterior=LOW; //estado inicial da entrada
}

void loop() {
  // put your main code here, to run repeatedly:

  boolean entrada_actual;

  // primeiro facemos a lectura das entradas:
  entrada_actual=digitalRead(PIN_ENTRADA);

  // compara o estado actual co anterior
  if( (entrada_actual==HIGH) && (entrada_anterior==LOW) ) 
  {
    digitalWrite(PIN_SAIDA,HIGH);
    delay(TEMPO_MS);
    digitalWrite(PIN_SAIDA,LOW);
  }

  //copia estado actual para o seguinte paso
  entrada_anterior=entrada_actual;

}

////////////////////////////////////////////////////////////////

