////////////////////////////////////////////////////////////////
//
//  PROGRAMA CONTROL DE MOTOR PASO A PASO UNIPOLAR CON ARDUINO
//
////////////////////////////////////////////////////////////////
// Este programa emprega o microcontrolador ATMEGA328P-PU (PDIP28)
// e un módulo de interfaz serie ttl-usb con ft232r

//definicións previas
#define PIN_AV    5
#define PIN_RET   6
#define PIN_Q0    9
#define PIN_Q1   10
#define PIN_Q2   11
#define PIN_Q3   12

#define MAX_CONTADOR 7
#define RETARDO_MS 10

////////////////////////////////////////////////////////////////
// define variables globais de entradas e saidas
boolean entrada_avance, entrada_retroceso;
boolean saida_q0, saida_q1, saida_q2, saida_q3;
unsigned char contador;

void setup() {
  // put your setup code here, to run once:
  // definición de entradas e saídas
  pinMode(PIN_AV,    INPUT);
  pinMode(PIN_RET,   INPUT);
  pinMode(PIN_Q0,   OUTPUT);
  pinMode(PIN_Q1,   OUTPUT);
  pinMode(PIN_Q2,   OUTPUT);
  pinMode(PIN_Q3,   OUTPUT);

  contador=0;
  // despraza o motor á posición indicada
  motor_paso(contador);

}

////////////////////////////////////////////////////////////////
void motor_paso(unsigned char valor)
{
  unsigned char posicion;

  posicion=0;
  // selecciona patrón de bits de saída en función da variable
  switch(valor)
  {
    case 0:  posicion=B00000001; break;
    case 1:  posicion=B00000011; break; 
    case 2:  posicion=B00000010; break;
    case 3:  posicion=B00000110; break;
    case 4:  posicion=B00000100; break;
    case 5:  posicion=B00001100; break;
    case 6:  posicion=B00001000; break;
    case 7:  posicion=B00001001; break; 
    default: posicion=B00000000; break;
  }
 
  saida_q0=bitRead(posicion,0);
  saida_q1=bitRead(posicion,1);
  saida_q2=bitRead(posicion,2);
  saida_q3=bitRead(posicion,3);

  digitalWrite(PIN_Q0,saida_q0);
  digitalWrite(PIN_Q1,saida_q1);
  digitalWrite(PIN_Q2,saida_q2);
  digitalWrite(PIN_Q3,saida_q3);
  
}
////////////////////////////////////////////////////////////////

void loop() {
  // put your main code here, to run repeatedly:

  // primeiro facemos a lectura das entradas:
  entrada_avance    = digitalRead(PIN_AV);
  entrada_retroceso = digitalRead(PIN_RET);

  // se está activa algunha entrada actualiza estado  
  if( (entrada_avance==HIGH) || (entrada_retroceso==HIGH) )
  {
    // se a entrada avance está activa incrementa cíclicamente o contador
    if(entrada_avance==HIGH) 
    { contador++;
      if(contador>MAX_CONTADOR) contador=0;
      delay(RETARDO_MS); }
  
    // se a entrada retroceso está activa decrementa cíclicamente o contador
    if(entrada_retroceso==HIGH) 
    { contador--;
      if(contador>MAX_CONTADOR) contador=MAX_CONTADOR;
      delay(RETARDO_MS); }
  
    // despraza o motor á posición indicada
    motor_paso(contador);
  }
  else
    motor_paso(MAX_CONTADOR+1); //saida 0

}

////////////////////////////////////////////////////////////////

