////////////////////////////////////////////////////////////////
//
//  PROGRAMA CONTROL DE MOTOR PASO A PASO UNIPOLAR CON ARDUINO
//
////////////////////////////////////////////////////////////////
// Este programa emprega o microcontrolador ATMEGA328P-PU (PDIP28)
// e un módulo de interfaz serie ttl-usb con ft232r
// motor 28BYJ-48 unipolar 4 bobinados
// circuíto controlador ULN2804A

//definicións entradas e saídas
#define MOTOR_UNIPOLAR_ESQUERDA_Q0 2
#define MOTOR_UNIPOLAR_ESQUERDA_Q1 3
#define MOTOR_UNIPOLAR_ESQUERDA_Q2 4
#define MOTOR_UNIPOLAR_ESQUERDA_Q3 5
#define MOTOR_UNIPOLAR_DEREITA_Q0 6
#define MOTOR_UNIPOLAR_DEREITA_Q1 7
#define MOTOR_UNIPOLAR_DEREITA_Q2 8
#define MOTOR_UNIPOLAR_DEREITA_Q3 9

#define RETARDO_PASO 2000 //retardo de paso dos motores en microsegundos

////////////////////////////////////////////////////////////////////////////////
// variables para motores
// matriz de pasos (gardada na memoria de programa)
const static uint8_t matriz_pasos[8][4] = 
{ 1, 0, 0, 0,
  1, 1, 0, 0,
  0, 1, 0, 0,
  0, 1, 1, 0,
  0, 0, 1, 0,
  0, 0, 1, 1,
  0, 0, 0, 1,
  1, 0, 0, 1 };

int8_t motor_esq_numpaso, motor_der_numpaso;
int8_t motor_esq_inc, motor_der_inc;

////////////////////////////////////////////////////////////////
// define variables globais de entradas e saidas
uint8_t entrada_avance, entrada_retroceso;

////////////////////////////////////////////////////////////////////////////////
//función que avanza un paso os motores
//parámetros: 1=xiro a dereita, -1=xiro a esquerda, 0=motor parado
//se o valor é 0 hai que desconectar as canles do motor, non deixar activada a actual!!
//o motor esquerdo do robot avanza con incremento -1, o dereito avanza con 1 e viceversa
void motor_paso(int8_t inc_esq, int8_t inc_der)
{
  // MOTOR ESQUERDO
  if(inc_esq==0) //se non hai incremento desconecta saídas
  { digitalWrite(MOTOR_UNIPOLAR_ESQUERDA_Q0, 0);
    digitalWrite(MOTOR_UNIPOLAR_ESQUERDA_Q1, 0);
    digitalWrite(MOTOR_UNIPOLAR_ESQUERDA_Q2, 0);
    digitalWrite(MOTOR_UNIPOLAR_ESQUERDA_Q3, 0); }
  else 
  { digitalWrite(MOTOR_UNIPOLAR_ESQUERDA_Q0, matriz_pasos[motor_esq_numpaso][0]);
    digitalWrite(MOTOR_UNIPOLAR_ESQUERDA_Q1, matriz_pasos[motor_esq_numpaso][1]);
    digitalWrite(MOTOR_UNIPOLAR_ESQUERDA_Q2, matriz_pasos[motor_esq_numpaso][2]);
    digitalWrite(MOTOR_UNIPOLAR_ESQUERDA_Q3, matriz_pasos[motor_esq_numpaso][3]); }

  //incremento cíclico da variable índice (0->1->2->3->4->5->6->7->0...)
  motor_esq_numpaso = motor_esq_numpaso + inc_esq; 
  //axusta resultado
  if(motor_esq_numpaso==8) motor_esq_numpaso=0;
  if(motor_esq_numpaso==-1) motor_esq_numpaso=7;

  // MOTOR DEREITO
  if(inc_der==0) //se non hai incremento desconecta saídas
  { digitalWrite(MOTOR_UNIPOLAR_DEREITA_Q0, 0);
    digitalWrite(MOTOR_UNIPOLAR_DEREITA_Q1, 0);
    digitalWrite(MOTOR_UNIPOLAR_DEREITA_Q2, 0);
    digitalWrite(MOTOR_UNIPOLAR_DEREITA_Q3, 0); }
  else 
  { digitalWrite(MOTOR_UNIPOLAR_DEREITA_Q0, matriz_pasos[motor_der_numpaso][0]);
    digitalWrite(MOTOR_UNIPOLAR_DEREITA_Q1, matriz_pasos[motor_der_numpaso][1]);
    digitalWrite(MOTOR_UNIPOLAR_DEREITA_Q2, matriz_pasos[motor_der_numpaso][2]);
    digitalWrite(MOTOR_UNIPOLAR_DEREITA_Q3, matriz_pasos[motor_der_numpaso][3]); }

  //incremento cíclico da variable índice (0->1->2->3->4->5->6->7->0...)
  motor_der_numpaso = motor_der_numpaso + inc_der; 
  //axusta resultado
  if(motor_der_numpaso==8) motor_der_numpaso=0;
  if(motor_der_numpaso==-1) motor_der_numpaso=7;

  delayMicroseconds(RETARDO_PASO);
  
}
////////////////////////////////////////////////////////////////
// función de inicialización
void setup() 
{
  //inicialización saidas para motores
  pinMode(MOTOR_UNIPOLAR_ESQUERDA_Q0, OUTPUT);
  pinMode(MOTOR_UNIPOLAR_ESQUERDA_Q1, OUTPUT);
  pinMode(MOTOR_UNIPOLAR_ESQUERDA_Q2, OUTPUT);
  pinMode(MOTOR_UNIPOLAR_ESQUERDA_Q3, OUTPUT);
  pinMode(MOTOR_UNIPOLAR_DEREITA_Q0,  OUTPUT);
  pinMode(MOTOR_UNIPOLAR_DEREITA_Q1,  OUTPUT);
  pinMode(MOTOR_UNIPOLAR_DEREITA_Q2,  OUTPUT);
  pinMode(MOTOR_UNIPOLAR_DEREITA_Q3,  OUTPUT);
  motor_esq_numpaso=0;
  motor_der_numpaso=0;
  motor_esq_inc=0;
  motor_der_inc=0;

}

////////////////////////////////////////////////////////////////
// función de bucle de programa

void loop() 
{
  motor_esq_inc=-1; motor_der_inc=1; //activa os dous motores
  
  motor_paso(motor_esq_inc, motor_der_inc); //avanza un paso en cada chamada
}

////////////////////////////////////////////////////////////////

