////////////////////////////////////////////////////////////////////////////////
//
//  PROGRAMA SIMULADOR DE PORTAS LÓXICAS CON ARDUINO
//
////////////////////////////////////////////////////////////////////////////////
// Este programa emprega o microcontrolador ATMEGA328P-PU con encapsulado PDIP28
// e un módulo de interfaz serie ttl-usb con ft232r

//  Taboa de verdade
//  
//           A B   S1
// -----------------
// FILA 0:   0 0   0
// FILA 1:   0 1   0 
// FILA 2:   1 0   0
// FILA 3:   1 1   1

//definicións previas
#define PIN_A 4
#define PIN_B 5
#define PIN_C 6
#define PIN_D 7
#define PIN_S1 0
#define PIN_S2 1
#define PIN_S3 2
#define PIN_S4 3
// definicións de niveis lóxicos para pulsadores e leds
// LOW=activo, HIGH=inactivo
#define NIVEL_OFF HIGH
#define NIVEL_ON  LOW
#define S1_FILA0 NIVEL_OFF  //modificar para cambiar a táboa!!
#define S1_FILA1 NIVEL_OFF
#define S1_FILA2 NIVEL_OFF
#define S1_FILA3 NIVEL_ON

////////////////////////////////////////////////////////////////

void setup() {
  // put your setup code here, to run once:
  // definición de entradas e saídas
  pinMode(PIN_A,INPUT);
  pinMode(PIN_B,INPUT);
  pinMode(PIN_C,INPUT);
  pinMode(PIN_D,INPUT);
  pinMode(PIN_S1, OUTPUT);
  pinMode(PIN_S2, OUTPUT);
  pinMode(PIN_S3, OUTPUT);
  pinMode(PIN_S4, OUTPUT);

  digitalWrite(PIN_S1,NIVEL_OFF);
  digitalWrite(PIN_S2,NIVEL_OFF);
  digitalWrite(PIN_S3,NIVEL_OFF);
  digitalWrite(PIN_S4,NIVEL_OFF);
}

void loop() {
  // put your main code here, to run repeatedly:

  boolean entrada_a, entrada_b, entrada_c, entrada_d, saida_s1, saida_s2;

  // primeiro facemos a lectura das entradas:
  entrada_a=digitalRead(PIN_A);
  entrada_b=digitalRead(PIN_B);
  entrada_c=digitalRead(PIN_C);
  entrada_d=digitalRead(PIN_D);

  // táboa de verdade
  // fila 0
  if( (entrada_d==NIVEL_OFF) && (entrada_c==NIVEL_OFF) ) saida_s1=S1_FILA0;
  // fila 1
  if( (entrada_d==NIVEL_OFF) && (entrada_c==NIVEL_ON)  ) saida_s1=S1_FILA1;
  // fila 2
  if( (entrada_d==NIVEL_ON)  && (entrada_c==NIVEL_OFF) ) saida_s1=S1_FILA2;
  // fila 3
  if( (entrada_d==NIVEL_ON)  && (entrada_c==NIVEL_ON)  ) saida_s1=S1_FILA3;

  digitalWrite(PIN_S1,saida_s1);
//  digitalWrite(PIN_S2,saida_s2);
}

////////////////////////////////////////////////////////////////

