///////////////////////////////////////////////////////////////////////////////////
// PROGRAMA VISUALIZADOR ESTÁTICO 7 SEGMENTOS CON REXISTROS 74595 
// versión arduino
///////////////////////////////////////////////////////////////////////////////////
//
// Visualizador 595 
// diagrama de conexións:
// FUNCIÓN    SIL-5
// GND        1
// VCC        2
// DATA I/O   3
// OUT ENABLE 4
// CLOCK      5
//
// conexións rexistro-díxito:
// Q0=b, Q1=a, Q2=c, Q3=dp, Q4=d, Q5=f, Q6=e, Q7=g
/*  valores para números: 
segmento A - B - C - D - E - F - G - DP   DATO  DIXITO
rexistro Q1  Q0  Q2  Q4  Q6  Q5  Q7  Q3   BCD   C.C.  A.C.
peso(0X) 02  01  04  10  40  20  80  08       
     1   1   1   1   1   1   0      0   0x77  0x88
     0   1   1   0   0   0   0      1   0x05  0xFA
     1   1   0   1   1   0   1      2   0xD3  0x2C
     1   1   1   1   0   0   1      3   0x97  0x68
     0   1   1   0   0   1   1      4   0xA5  0x5A
     1   0   1   1   0   1   1      5   0xB6  0x49
     0   0   1   1   1   1   1      6   0xF4  0x0B
     1   1   1   0   0   0   0      7   0x07  0xF8
     1   1   1   1   1   1   1      8   0xF7  0x08
     1   1   1   0   0   1   1      9   0xA7  0x58
    
NOTAS: 
valores para cátodo común, invertir para ánodo común
|0x08 para activar o punto decimal en cátodo común, &0xf7 en ánodo común
*/

// definición tipo de visualizador (ánodo común ou cátodo común)
#define PUNTO_DECIMAL 0x08 //valor a engadir para activar o punto decimal
#define ANODO_COMUN 0xff  //valor de inversión para ánodo común
#define CATODO_COMUN 0x00 //valor de inversión para cátodo común
//#define TIPO_DISPLAY CATODO_COMUN
#define TIPO_DISPLAY ANODO_COMUN

// definición de conexións de entrada para placa arduino
#define VIS595_VPOS A0 //entrada de tensión positiva
#define VIS595_VNEG A1 //entrada de tensión negativa
#define VIS595_DAT  A2 //vis595 liña de datos
#define VIS595_OE   A3 //vis595 liña de control de saídas (pwm)
#define VIS595_CLK  A4 //vis595 liña de clock

// valores de retardos en ms para delayMicroseconds()
// cristal cuarzo 16MHz
#define RETARDO_INI595 1000 //para 16MHz (texto inicio)
#define RETARDO_VIS595 5000 //para 16MHz
#define RETARDO_DAT595 100 //para 16MHz

///////////////////////////////////////////////////////////////////////////////////
void delay_595()
{
//  delay(RETARDO_DAT595);
  delayMicroseconds(RETARDO_DAT595);
}
///////////////////////////////////////////////////////////////////////////////////
// pulso clk: espera-subida-espera-baixada
void clk_595()
{
//  delay(RETARDO_DAT595);
  delayMicroseconds(RETARDO_DAT595);
  digitalWrite(VIS595_CLK, HIGH);
//  delay(RETARDO_DAT595);
  delayMicroseconds(RETARDO_DAT595);
  digitalWrite(VIS595_CLK, LOW);
}
///////////////////////////////////////////////////////////////////////////////////
// matriz de datos de conversión de saidas Q0-7 a segmentos
// definida como const para que se almacene en memoria de programa
// (senón ocuparía toda a ram interna)
// caracteres ascii: 0x30='0', 0x41='A', 0x61='a'

const unsigned char datos_segmentos[256]=
 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' (ascii 0x30-0x3f)
  0x77,0x05,0xd3,0x97,0xa5,0xb6,0xf4,0x07,0xf7,0xa7,0x00,0x00,0x00,0x00,0x00,0x00,
//      'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 
  0x00,0xE7,0xF7,0x72,0x77,0xF2,0xE2,0xF6,0xE5,0x05,0x15,0x00,0x70,0x00,0x00,0x77,
// 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'  (ascii 0x50-0x5f)
  0xE3,0x00,0xE7,0xB6,0x00,0x75,0x75,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
//      'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 
  0x00,0xD7,0xF4,0xD0,0xD5,0xF2,0xE2,0xB7,0xE4,0x05,0x14,0x00,0x60,0x00,0xC4,0xD4,
// 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'  (ascii 0x70-0x7f)
  0xE3,0xA7,0xC0,0xB6,0xF0,0x54,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// ascii 0x80-0xff (sen uso)
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 };

///////////////////////////////////////////////////////////////////////////////////
// esta función envía 8 bits consecutivos ós rexistros de desprazamento
// non inicia nin finaliza o estado do visualizador
// tampouco fai a conversión de datos
void dato_595(unsigned char dato)
{
  //envía datos en serie empezando polo máis alto 
  //(no rexistro os bits entran por Q0)
  if(dato&0x80) digitalWrite(VIS595_DAT,HIGH); else digitalWrite(VIS595_DAT,LOW); clk_595();
  if(dato&0x40) digitalWrite(VIS595_DAT,HIGH); else digitalWrite(VIS595_DAT,LOW); clk_595();
  if(dato&0x20) digitalWrite(VIS595_DAT,HIGH); else digitalWrite(VIS595_DAT,LOW); clk_595();
  if(dato&0x10) digitalWrite(VIS595_DAT,HIGH); else digitalWrite(VIS595_DAT,LOW); clk_595();
  if(dato&0x08) digitalWrite(VIS595_DAT,HIGH); else digitalWrite(VIS595_DAT,LOW); clk_595();
  if(dato&0x04) digitalWrite(VIS595_DAT,HIGH); else digitalWrite(VIS595_DAT,LOW); clk_595();
  if(dato&0x02) digitalWrite(VIS595_DAT,HIGH); else digitalWrite(VIS595_DAT,LOW); clk_595();
  if(dato&0x01) digitalWrite(VIS595_DAT,HIGH); else digitalWrite(VIS595_DAT,LOW); clk_595();
}
///////////////////////////////////////////////////////////////////////////////////
// esta función envía 8 bits consecutivos ós rexistros de desprazamento
// non inicia nin finaliza o estado do visualizador
// esta función fai a conversión de datos usando a matriz de datos ascii
// tamén fai a inversión para ánodo común e engade o punto decimal 
// dp: punto decimal, 0=non, 1=sí
// tipo: 0x00=cátodo común, 0xff=ánodo común
void dato_ascii_595(unsigned char dato, unsigned char dp, unsigned char tipo)
{
  // conversión de datos ascii-segmentos
  dato=datos_segmentos[dato]; //equivalencia dato-saidas dos rexistros Q0-Q7
  if(dp==1) dato=dato+PUNTO_DECIMAL; //engade punto decimal se está activo
  //complemento de bits para díxitos de ánodo común
  dato=dato^tipo; //faise mediante or-exclusivo con 0x00 (igual) ou 0xff (invirte)
  //envía datos en serie empezando polo máis alto 
  //(no rexistro os bits entran por Q0)
  if(dato&0x80) digitalWrite(VIS595_DAT,HIGH); else digitalWrite(VIS595_DAT,LOW); clk_595();
  if(dato&0x40) digitalWrite(VIS595_DAT,HIGH); else digitalWrite(VIS595_DAT,LOW); clk_595();
  if(dato&0x20) digitalWrite(VIS595_DAT,HIGH); else digitalWrite(VIS595_DAT,LOW); clk_595();
  if(dato&0x10) digitalWrite(VIS595_DAT,HIGH); else digitalWrite(VIS595_DAT,LOW); clk_595();
  if(dato&0x08) digitalWrite(VIS595_DAT,HIGH); else digitalWrite(VIS595_DAT,LOW); clk_595();
  if(dato&0x04) digitalWrite(VIS595_DAT,HIGH); else digitalWrite(VIS595_DAT,LOW); clk_595();
  if(dato&0x02) digitalWrite(VIS595_DAT,HIGH); else digitalWrite(VIS595_DAT,LOW); clk_595();
  if(dato&0x01) digitalWrite(VIS595_DAT,HIGH); else digitalWrite(VIS595_DAT,LOW); clk_595();
  

}

///////////////////////////////////////////////////////////////////////////////////
// función que inicia o envío de datos ós rexistros 595
void inicio_595()
{
  //desactiva CLK e apaga visualizador mentres se envían datos
  digitalWrite(VIS595_OE, HIGH);
  digitalWrite(VIS595_CLK, LOW);
  delay_595();
}

///////////////////////////////////////////////////////////////////////////////////
// función que remata o envío de datos ós rexistros 595
void fin_595()
{
  //envía un bit adicional para desprazar os datos dos rexistros de entrada ós de saída
  clk_595();  
  //activa visualizador
  digitalWrite(VIS595_OE, LOW);
  delay_595();
}

///////////////////////////////////////////////////////////////////////////
/* función que envía ó display a cadena de caracteres indicada ata que atope 
   o valor 0. A visualización faise a partir da posición actual do cursor
   esta función non salta liñas do display */
void viscad_595(const char* cad, unsigned char tipo)
{
  unsigned char i;
  
  inicio_595();

  for(i=0;i<8;i++)
  { //engade caracteres
    dato_ascii_595(cad[i],0,tipo);
  }
  
  fin_595(); //encende o visualizador

}

///////////////////////////////////////////////////////////////////////////////////
// dato: valor enteiro entre 0 e 9999
// dp: posición do punto decimal, 0=non, 1-2-3-4 no díxito correspondente
// tipo: 0x00=cátodo común, 0xff=ánodo común
// con ánodo común hai que invertir os bits 
// non inicia nin finaliza o estado do visualizador
void vis4dix_595(unsigned int dato, unsigned char dp, unsigned char tipo)
{
  //matriz de datos de segmentos para valores 0-9, o subíndice 10 é o punto decimal 
  unsigned int cociente, resto;
  unsigned char valor;

  // DIXITO 1 (milleiros) 
  cociente=dato/1000;
  resto=dato%1000;
  valor=(unsigned char)cociente; //cambiamos o tipo de variable (casting)
  valor=valor|0x30; //engade 0x30 para formar o código ascii da cifra
  valor=datos_segmentos[valor]; //equivalencia dato-saidas dos rexistros Q0-Q7
  if(dp==1) valor=valor+PUNTO_DECIMAL; //engade punto decimal se está activo
  //complemento de bits para díxitos de ánodo común
  valor=valor^tipo; //faise mediante or-exclusivo con 0x00 (igual) ou 0xff (invirte)
  dato_595(valor); //envía dato en serie ós rexistros

  //copio o resto anterior no dato
  dato=resto;
  
  // DIXITO 2 (centenas)  
  cociente=dato/100;
  resto=dato%100;
  valor=(unsigned char)cociente; //cambiamos o tipo de variable (casting)
  valor=valor|0x30; //engade 0x30 para formar o código ascii da cifra
  valor=datos_segmentos[valor]; //equivalencia dato-saidas dos rexistros Q0-Q7
  if(dp==2) valor=valor+PUNTO_DECIMAL; //engade punto decimal se está activo
  //complemento de bits para díxitos de ánodo común
  valor=valor^tipo; //faise mediante or-exclusivo con 0x00 (igual) ou 0xff (invirte)
  dato_595(valor); //envía dato en serie ós rexistros

  //copio o resto anterior no dato
  dato=resto;
  
  // DIXITO 3 (decenas) 
  cociente=dato/10;
  resto=dato%10;
  valor=(unsigned char)cociente; //cambiamos o tipo de variable (casting)
  valor=valor|0x30; //engade 0x30 para formar o código ascii da cifra
  valor=datos_segmentos[valor]; //equivalencia dato-saidas dos rexistros Q0-Q7
  if(dp==3) valor=valor+PUNTO_DECIMAL; //engade punto decimal se está activo
  //complemento de bits para díxitos de ánodo común
  valor=valor^tipo; //faise mediante or-exclusivo con 0x00 (igual) ou 0xff (invirte)
  dato_595(valor); //envía dato en serie ós rexistros

  // DIXITO 4 (unidades)  
  // o último valor é directamente o resto anterior
  valor=(unsigned char)resto; //cambiamos o tipo de variable (casting)
  valor=valor|0x30; //engade 0x30 para formar o código ascii da cifra
  valor=datos_segmentos[valor]; //equivalencia dato-saidas dos rexistros Q0-Q7
  if(dp==4) valor=valor+PUNTO_DECIMAL; //engade punto decimal se está activo
  //complemento de bits para díxitos de ánodo común
  valor=valor^tipo; //faise mediante or-exclusivo con 0x00 (igual) ou 0xff (invirte)
  dato_595(valor); //envía dato en serie ós rexistros

}
/////////////////////////////////////////////////////////////////////////////////////////

void setup() 
{
  // código de inicialización do programa

  //definición de uso de entradas e saídas
  pinMode(VIS595_OE,  OUTPUT);
  pinMode(VIS595_CLK, OUTPUT);
  pinMode(VIS595_DAT, OUTPUT);

}

/////////////////////////////////////////////////////////////////////////////////////////

char cadena1[]="    8888";

void loop() 
{
  // parte do código que se repite indefinidamente
  unsigned int i;


  for(i=0;i<9999;i++)
  {
    sprintf(cadena1,"    %04d",i);
    viscad_595(cadena1,TIPO_DISPLAY);
    delay(5);
  }


}

/////////////////////////////////////////////////////////////////////////////////////////

